<?php

// php code to calculate LFG flow (cfm) from user input data with the QED orifice
// plate system
// Copyright QED Environmental 2013
// Ver. 0.1 -- DAF 2/2013
//
// Rev 1 -- 5-16-2013 -- Add capability for 1-1/4 orifice device -- DAF

// Some constants
$ori_cv = 0.65;
$gas_c = 32.17;
$p_atm = 14.6954;
$mw_ch4 = 16.043;
$mw_co2 = 44.01;
$sp_ratio = 1.3;
$err_flag = 0;
$err = '';
$gas_txt = '';

$temp = $_GET['temp'];
$lfg = $_GET['lfg'];
$delta = $_GET['delta'];
$applied = $_GET['applied']; 
$pipe = $_GET['pipe'];
$plate = $_GET['plate'];

// Echo back what the user submitted

// debug -- $display_string = "<p>Temp $temp</p><p>LFG $lfg</p><p>delta $delta</p><p>applied $applied</p><p>pipe $pipe</p><p>plate $plate</p>";

// Calculate effective LFG density CH4/CO2 -- like 60/40
// Add option to use AIR = MW of 28.97
if ($lfg == 'AIR')
{
    $mw_lfg = 28.97;
    $gas_txt = 'AIR';
    $temp_c = ($temp - 32)/1.8;
}
else
{
    $tmp = explode ('/',$lfg);
    if (($tmp[0] + $tmp[1]) == 100)
    {
        $per_ch4 = $tmp[0]/100;
        $per_co2 = $tmp[1]/100;
        $temp_c = ($temp - 32)/1.8;
        // effective MW of LFG
        $mw_lfg = ($mw_ch4 * $per_ch4) + ($mw_co2 * $per_co2);
        $gas_txt = 'LFG';
    }
    elseif (($tmp[0] + $tmp[1]) < 100)
    {
    	$bal = 100 - ($tmp[0] + $tmp[1]);
        $per_ch4 = $tmp[0]/100;
        $per_co2 = $tmp[1]/100;
        $per_air = $bal/100;
        $temp_c = ($temp - 32)/1.8;
        // effective MW of LFG
        $mw_lfg = ($mw_ch4 * $per_ch4) + ($mw_co2 * $per_co2) + (28.97 * $per_air);
        $gas_txt = 'LFG (bal=AIR)';    
    }
    else
    {
        $per_ch4 = $tmp[0]/($tmp[0] + $tmp[1]);
        $per_co2 = $tmp[1]/($tmp[0] + $tmp[1]);
        $temp_c = ($temp - 32)/1.8;
        // effective MW of LFG
        $mw_lfg = ($mw_ch4 * $per_ch4) + ($mw_co2 * $per_co2);
        $gas_txt = 'LFG (ratio fix)';
    }
}

// density in kg/m3 $mw_lfg/(($temp_c + 273.15)*0.0821)
$den_lfg_1 = $mw_lfg/(($temp_c + 273.15)*0.0821);
// density in lbs/ft3 $den_lfg_1 * 0.06242796
$den_lfg_2 = $den_lfg_1 * 0.06242796;

// debug -- $display_string .= "<p>Per CH4 $per_ch4</p><p>Per CO2 $per_co2</p><p>LFG MW $mw_lfg</p><p>Density (kg/m3) $den_lfg_1</p><p>Density (lb/ft3) $den_lfg_2</p>";

// Calculate Beta - orifice diameter ratio orifice/pipe
// Lookup plate ID from select tag
switch ($plate) {
    case '026':
        $plate_diam = 0.26;
        if ($pipe == '3'){$err = 'Orifice for 1.25-inch pipe and 2-inch pipe'; $err_flag = 1;}
        break;	
    case '040':
        $plate_diam = 0.40;
        if ($pipe == '1' || $pipe == '3'){$err = 'Orifice for 2-inch pipe'; $err_flag = 1;}
        break;
    case '050':
        $plate_diam = 0.50;
        if ($pipe == '3'){$err = 'Orifice for 1.25 and 2-inch pipe'; $err_flag = 1;}
        break;
    case '075':
        $plate_diam = 0.75;
        // -- OK for all -- if ($pipe == '3'){$err = 'Orifice for 1.25 and 2-inch pipe'; $err_flag = 1;}
        break;
    case '095':
        $plate_diam = 0.95;
        if (($pipe == '2') or ($pipe == '3')){$err = 'Orifice for 1.25-inch pipe'; $err_flag = 1;}
        break;	        
    case '100':
        $plate_diam = 1.00;
        if ($pipe == '1' || $pipe == '3'){$err = 'Orifice for 2-inch pipe'; $err_flag = 1;}
        break;
    case '125':
        $plate_diam = 1.25;
        if ($pipe == '1'){$err = 'Orifice for 2 and 3-inch pipe'; $err_flag = 1;}
        break;
    case '140':
        $plate_diam = 1.40;
        if ($pipe == '1' || $pipe == '3'){$err = 'Orifice for 2-inch pipe'; $err_flag = 1;}
        break;
    case '160':
        $plate_diam = 1.60;
        if ($pipe == '1' || $pipe == '3'){$err = 'Orifice for 2-inch pipe'; $err_flag = 1;}
        break;
    case '175':
        $plate_diam = 1.75;
        if ($pipe == '1' || $pipe == '2'){$err = 'Orifice for 3-inch pipe'; $err_flag = 1;}
        break;
    case '210':
        $plate_diam = 2.10;
        if ($pipe == '1' || $pipe == '2'){$err = 'Orifice for 3-inch pipe'; $err_flag = 1;}
        break;
    case '225':
        $plate_diam = 2.25;
        if ($pipe == '1' || $pipe == '2'){$err = 'Orifice for 3-inch pipe'; $err_flag = 1;}
        break;
   case '240':
        $plate_diam = 2.40;
        if ($pipe == '1' || $pipe == '2'){$err = 'Orifice for 3-inch pipe'; $err_flag = 1;}
        break;
}
if ($pipe == '1'){$pipe_diam = 1.255;}
if ($pipe == '2'){$pipe_diam = 1.939;}
if ($pipe == '3'){$pipe_diam = 2.9;}

$beta = $plate_diam/$pipe_diam;
// debug -- $display_string .= "<p>Pipe $pipe_diam</p><p>Plate $plate_diam</p><p>Beta $beta</p>";

// Calculate K = Cv/((1-(beta^4))^0.5)
$k = $ori_cv/pow((1-(pow($beta,4))),0.5);
// debug -- $display_string .= "<p>K $k</p>";

// Calculate throat area A2 = 3.14159*((I32/12)/2)^2
$a2 = pi()*pow((($plate_diam/12)/2),2);
// debug -- $display_string .= "<p>A2 $a2</p>";

// Calculate $delta_lbft2 = $delta*144; (convert delta to psi / by 27.6
$delta_lbft2 = $delta*(144/27.6);
// debug -- $display_string .= "<p>Delta (lb/ft2) $delta_lbft2</p>";

// Calc $applied_lbft2 =($applied/27.6)/144;
$applied_lbft2 =($applied/27.6)/144;
// debug -- $display_string .= "<p>Applied (lb/ft2) $applied_lbft2</p>";

// Calculate $p2 = $p_atm-($applied/(2.3*12));
$p2 = $p_atm-($applied/(2.3*12));
// debug -- $display_string .= "<p>p2 $p2</p>";

// Calculate $r = $p_atm/$p2;
$r = $p_atm/$p2;
// debug -- $display_string .= "<p>r $r</p>";

// Calculate $y = 1-((1-$r)/$sp_ratio)*(0.41+(0.35*(($beta^4))))
$y = 1-((1-$r)/$sp_ratio)*(0.41+(0.35*(pow($beta,4))));
// debug -- $display_string .= "<p>y $y</p>";

// Calculate mass discharge =($k*$y*$a2)*(SQRT(2*$gas_c*$delta_lbft2*$den_lfg_2)) 
$mass_disch = ($k*$y*$a2)*(SQRT(2*$gas_c*$delta_lbft2*$den_lfg_2));
// debug -- $display_string .= "<p>MASS DISCH $mass_disch</p>";

// Calculate Q_cfs = $mass_disch/$den_lfg_2
$q_cfs = $mass_disch/$den_lfg_2;
// debug -- $display_string .= "<p>CFS $q_cfs</p>";

// Calculate Q_cfm = $q_cfs * 60
$q_cfm = $q_cfs * 60;
// debug -- $display_string .= "<p>CFM $q_cfm</p>";

// Display some research values - Re, LFG density, LFG viscosity, etc.
// viscosity of LFG assumed to be a constant = 1.15E-5 (EPA-600/R-05/123a)
// $a3(ft2); $vel(m/s); $pipe_diam(in); $pipe_diam_met(m);
$a3 = pi()*pow((($pipe_diam/12)/2),2);
$vel = $q_cfm/($a3*60);
$vel_m = $vel*0.3048;
$pipe_diam_met = $pipe_diam/39.36996;

if ($lfg == 'AIR'){$rey = $den_lfg_1*$vel_m*$pipe_diam_met/0.0000145;}
else {$rey = $den_lfg_1*$vel_m*$pipe_diam_met/0.0000101;}

if ($rey <= 2000){$flow_type = 'laminar';}
elseif ($rey >= 3000){$flow_type = 'turbulent';}	
else{$flow_type = 'transitional';}

if (($beta >= 0.2)&&($beta <= 0.6)){$beta_rule = 'ideal';}
elseif (($beta > 0.6)&&($beta <= 0.7)){$beta_rule = '0.5-percent error';}
elseif (($beta >= 0.1)&&($beta <= 0.7)){$beta_rule = 'more than 0.5-percent error';}
else{$beta_rule = 'not rcommended';}

$rey = number_format($rey,2);
$beta  = number_format($beta,2);
$vel = number_format($vel,2);
$eng_txt_1 = 'Beta = '.$beta.' ('.$beta_rule.')';
$eng_txt_2 = 'Velocity (ft/s) = '.$vel.' Reynolds = '.$rey.' ('.$flow_type.')';

// Create CFM output
//$q_cfm = number_format($q_cfm,2);
$q_cfm = number_format($q_cfm,1);

//$display_string = "<TABLE BORDER='1' WIDTH='20%'><TR><TD bgcolor='#FAF7B2' WIDTH='50%'>LFG Flow (cfm)</TD><TD bgcolor='#FFFFFF'>$q_cfm</TD></TR></TABLE>";
if($err_flag == '1')
{
   $display_string = "<TABLE BORDER='1' WIDTH='20%'><TR><TD WIDTH='50%' CLASS='cl7'><B>ERROR</B></TD><TD CLASS='cl5'><B>$err</B></TD></TR></TABLE>";
}
else
{
   $display_string = "<TABLE BORDER='1' WIDTH='20%'><TR><TD WIDTH='50%' CLASS='cl7'><B>$gas_txt Flow (cfm)</B></TD><TD CLASS='cl5'><B>$q_cfm</B></TD></TR><TR><TD COLSPAN='2' CLASS='cl5'><B>$eng_txt_1</B></TD></TR></TR><TR><TD COLSPAN='2' CLASS='cl5'><B>$eng_txt_2</B></TD></TR></TABLE>";
}

echo $display_string;
?>

